﻿//////////////////////////////////////////////
// BlurComplexEffect.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class System ;
}

namespace nkGraphics
{
	class Sampler ;
	class Shader ;
	class TargetOperations ;
	class Texture ;
	class Viewport ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

#include "../ComplexEffect.h"

#include "BlurComplexEffectInfo.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT BlurComplexEffect final : public ComplexEffect
	{
		public :

			// Constructor, destructor
			BlurComplexEffect (System* system) noexcept ;
			virtual ~BlurComplexEffect () ;

			// Getters
			nkGraphics::Texture* getSourceTexture () const ;
			nkGraphics::Texture* getOutputTexture () const ;
			unsigned int getKernelRadius () const ;
			bool getAlphaEncodesBlurPlanes () const ;
			bool getPreserveAlpha () const ;

			// Setters
			void setSourceTexture (nkGraphics::Texture* value) ;
			void setKernelRadius (unsigned int value) ;
			void setAlphaEncodesBlurPlanes (bool value) ;
			void setPreserveAlpha (bool value) ;

			// Load
			virtual bool load () override ;
			virtual void unload () override ;

		public :

			// Statics
			static nkMemory::UniquePtr<BlurComplexEffect> create (System* system = nullptr) ;

		private :

			// Functions
			// Texture creations 
			bool _prepareTextures () ;
			bool _prepareSamplers () ;

			// Viewport handling
			bool _prepareViewport () ;

			// Shaders creations
			bool _prepareShaders () ;

		private :

			// Attributes
			System* _system ;

			// Program
			BlurComplexEffectInfo _loadedInfo ;
			nkGraphics::CompositorNode* _loadedNode ;

			// Info
			BlurComplexEffectInfo _info ;

			// Resources
			nkMemory::UniquePtr<nkGraphics::Texture> _firstPassTexture ;
			nkMemory::UniquePtr<nkGraphics::Texture> _secondPassTexture ;
			nkMemory::UniquePtr<nkGraphics::Shader> _firstPassShader ;
			nkMemory::UniquePtr<nkGraphics::Shader> _secondPassShader ;
			nkMemory::UniquePtr<nkGraphics::Viewport> _viewport ;
			nkMemory::UniquePtr<nkGraphics::Sampler> _sampler ;

			nkGraphics::TargetOperations* _firstOp ;
			nkGraphics::TargetOperations* _secondOp ;
	} ;
}